package com.example.gmadapter;

import android.app.Activity;
import android.content.Context;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.reward.MediationCustomRewardVideoLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationRewardItem;
import com.open.ad.polyunion.bean.CAdInfo;
import com.open.ad.polyunion.listener.RewardVideoListener;
import com.open.ad.polyunion.view.AdConfig;
import com.open.ad.polyunion.view.AdRequestConfig;
import com.open.ad.polyunion.view.AdView;

import java.util.Map;


/**
 * 激励视频
 * */
public class CloooudMediationCustomRewardVideoLoader extends MediationCustomRewardVideoLoader {

    private AdView rewardVideo;

    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {
        if(!(context instanceof Activity)){
            return;
        }
        AdRequestConfig requestConfig = new AdRequestConfig.Builder()
                .AdType(AdConfig.AD_TYPE_REWARDVIDEO)
                .requestTimeOutMillis(10000) //设置聚合SDK请求前超时时间，毫秒
                .slotId(mediationCustomServiceConfig.getADNNetworkSlotId()) //广告场景id
                .build();
        rewardVideo = new AdView((Activity) context, requestConfig);
        rewardVideo.setRewardVideoListener(new RewardVideoListener() {

            @Override
            public void onAdFailed(String msg) {
                callLoadFail(9999, msg);
            }

            @Override
            public void onVideoComplete() {
                callRewardVideoSkippedVideo();
            }

            @Override
            public void onAdReward() {
                callRewardVideoRewardVerify(new MediationRewardItem() {
                    @Override
                    public boolean rewardVerify() {
                        return true;
                    }

                    @Override
                    public float getAmount() {
                        return 3;
                    }

                    @Override
                    public String getRewardName() {
                        return "";
                    }

                    @Override
                    public Map<String, Object> getCustomData() {
                        return null;
                    }
                });
            }

            @Override
            public void onAdClose() {
                callRewardVideoAdClosed();
            }

            @Override
            public void onAdReady(int price) {
                if (isClientBidding()) {
                    double ecpm = price;
                    if (ecpm < 0) {
                        ecpm = 0;
                    }
                    callLoadSuccess(ecpm);
                } else {
                    callLoadSuccess();
                }
            }

            @Override
            public void onVideoCached() {

            }

            @Override
            public void onAdShow(CAdInfo cAdInfo) {
                callRewardVideoAdShow();
            }

            @Override
            public void onAdClick(String s) {
                callRewardVideoAdClick();
            }
        });

    }

    /**
     * 是否clientBidding广告
     *
     * @return
     */
    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }

    @Override
    public MediationConstant.AdIsReadyStatus isReadyCondition() {
        if(rewardVideo != null && rewardVideo.isRewardVideoOk()){
            return MediationConstant.AdIsReadyStatus.AD_IS_READY;
        } else {
            return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }



    @Override
    public void showAd(Activity activity) {
        if(rewardVideo != null && rewardVideo.isRewardVideoOk()){
            rewardVideo.showRewardVideoAd(activity);
        }
    }
}
