package com.example.gmadapter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.splash.MediationCustomSplashLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.open.ad.polyunion.bean.CAdInfo;
import com.open.ad.polyunion.listener.AdViewListener;
import com.open.ad.polyunion.view.AdConfig;
import com.open.ad.polyunion.view.AdRequestConfig;
import com.open.ad.polyunion.view.AdView;


/**
 * 开屏
 * */
public class CloooudMediationCustomSplashLoader extends MediationCustomSplashLoader {
    private static final String TAG = "CloooudMediationSDK";
    private AdView splash;
    // 开屏广告视图父容器
    protected RelativeLayout mSplashRootContainer;

    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {
        if(!(context instanceof Activity)){
            return;
        }
        // 开屏广告则初始化视图容器
        mSplashRootContainer = new RelativeLayout(context.getApplicationContext());
        int[] screenSizeDP = Util.getScreenSizeInDP(context);
        AdRequestConfig requestConfig = new AdRequestConfig.Builder()
                .AdType(AdConfig.AD_TYPE_SPLASH)
                .requestTimeOutMillis(10000) //设置聚合SDK请求前超时时间，毫秒
                .slotId(mediationCustomServiceConfig.getADNNetworkSlotId()) //广告场景id
                .widthDp(screenSizeDP[0]) //请求图片宽度dp值
                .heightDp(screenSizeDP[1]) //需要传广告展示的高度
                .splashContainer(mSplashRootContainer) //设置开屏广告view容器
                .build();
        splash = new AdView((Activity) context, requestConfig);
        splash.setListener(new AdViewListener() {
            @Override
            public void onAdClick() {
                callSplashAdClicked();
            }

            @Override
            public void onAdFailed(String msg) {
                callLoadFail(9999, msg);
            }

            @Override
            public void onAdReady(int price) {
                if (isClientBidding()) {
                    double ecpm = price;
                    if (ecpm < 0) {
                        ecpm = 0;
                    }
                    callLoadSuccess(ecpm);
                } else {
                    callLoadSuccess();
                }
            }

            @Override
            public void onAdShow(CAdInfo cAdInfo) {
                callSplashAdShow();
            }

            @Override
            public void onAdDismissed(String s) {
                callSplashAdSkip();

            }
        });
    }

    @Override
    public MediationConstant.AdIsReadyStatus isReadyCondition() {
        Log.e("CLOOOUD_POLY", "isReadyCondition: "+(splash == null) );
        if(splash != null){
            return MediationConstant.AdIsReadyStatus.AD_IS_READY;
        } else {
            return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }

    /**
     * 是否clientBidding广告
     *
     * @return
     */
    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }

    @Override
    public void showAd(ViewGroup viewGroup) {
      if(splash != null && viewGroup != null){
          // 将SDK广告视图放入应用提供的容器
          RelativeLayout.LayoutParams lpRoot = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                  ViewGroup.LayoutParams.MATCH_PARENT);
          viewGroup.addView(mSplashRootContainer,lpRoot);
          splash.showSplashAd();
      }
    }
}
