package com.example.gmadapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.bytedance.sdk.openadsdk.mediation.ad.MediationNativeAdAppInfo;
import com.bytedance.sdk.openadsdk.mediation.ad.MediationViewBinder;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.native_ad.MediationCustomNativeAd;
import com.open.ad.polyunion.bean.CAdInfo;
import com.open.ad.polyunion.view.NativeAdsResponse;

import java.util.List;

/**
 * @author zw
 * @date :2024/4/28 18:26
 * @projectName
 * @description:
 */
public class CFeedNativeAD extends MediationCustomNativeAd {

    private NativeAdsResponse response;
    private Context context;

    private FrameLayout  mContainer;

    public CFeedNativeAD(Context context, NativeAdsResponse response) {
        this.context = context;
        this.response = response;

        response.setNativeActionListener(new NativeAdsResponse.NativeActionListener() {
            @Override
            public void onAdClick() {
                callAdClick();
            }

            @Override
            public void onAdShow(CAdInfo cAdInfo) {
                callAdShow();
            }

            @Override
            public void onError(String msg) {

            }

            @Override
            public void onAdClose(String dislikeReason) {
                callDislikeSelected(0,dislikeReason);
            }

            @Override
            public void onExpressRenderFail(String msg) {

            }

            @Override
            public void onExpressRenderSuccess(View view, float width, float height) {
                callRenderSuccess(width,height);
            }

            @Override
            public void onExpressRenderTimeout() {

            }

            @Override
            public void onDislikeDialogShow() {
                callDislikeShow();
            }

            @Override
            public void onDownloadConfirmDialogDismissed() {

            }
        });

        this.setActionText("点击查看");
        this.setDescription(response.getDesc()); //描述
        this.setIconUrl(response.getImageUrl());
        String appName = !TextUtils.isEmpty(response.getAppName()) ? response.getAppName() : "";
        this.setSource(appName); // appName
        this.setTitle(response.getTitle()); // appName
//        this.setExpressAd(false);
        this.setStarRating(4.8);
        this.setAdImageMode(3);
        if(response.getInteractionType() == 2){
            this.setInteractionType(4);
        } else {
            this.setInteractionType(2);
        }

        this.setImageList(response.getImageUrls());
        this.setImageUrl(response.getImageUrl());
        MediationNativeAdAppInfo appInfo = new MediationNativeAdAppInfo();
        appInfo.setAppName(response.getAppName());
        appInfo.setPermissionsMap(response.getPermissionsMap());
        appInfo.setVersionName(response.getAppVersion());
        appInfo.setPrivacyAgreement(response.getPrivacyUrl());
        appInfo.setPermissionsUrl(response.getPermissionInfoUrl());
        appInfo.setAuthorName(response.getDeveloperName());
        this.setNativeAdAppInfo(appInfo);
        if (response.isExpressAd()) {
            this.setExpressAd(true);
            // 模板广告开始渲染
            response.render();
        }
//        this.setImageHeight(image.getHeight());
//        this.setImageWidth(image.getWidth());

    }


    @Override
    public View getExpressView() {
        try {
            if (response != null) {
                View view = response.getExpressAdView();
                RelativeLayout adContainer = new RelativeLayout(context);
                RelativeLayout.LayoutParams lpRoot = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                        ViewGroup.LayoutParams.WRAP_CONTENT);
                adContainer.setLayoutParams(lpRoot);
                // 注册原生信息流广告可点击区域视图，建议为客户端单个原生广告位所有区域，在广告展现时调用
                response.registerNativeClickableView(adContainer, context, adContainer, null);
                if (view == null) {
                    return adContainer;
                }
                return view;
            }
            return null;
        } catch (Throwable e) {
            Log.e("CLOOOUD", "getExpressView: "+e.getMessage() );
        }
        return null;
    }


    @Override
    public void registerView(Activity activity, ViewGroup viewGroup, List<View> list, List<View> list1, List<View> list2, MediationViewBinder mediationViewBinder) {
        super.registerView(activity, viewGroup, list, list1, list2, mediationViewBinder);
        if(response != null){
            // 注册原生信息流广告可点击区域视图，建议为客户端单个原生广告位所有区域，在广告展现时调用
            response.registerNativeClickableView(
                    viewGroup,
                    activity,
                    viewGroup,
                    null);
        }
    }
}
