package com.example.gmadapter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.banner.MediationCustomBannerLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.open.ad.polyunion.bean.CAdInfo;
import com.open.ad.polyunion.listener.AdViewListener;
import com.open.ad.polyunion.view.AdConfig;
import com.open.ad.polyunion.view.AdRequestConfig;
import com.open.ad.polyunion.view.AdView;


/**
 * banner
 * */
public class CloooudMediationCustomBannerLoader extends MediationCustomBannerLoader {

    private static final String TAG = "CCustomerBanner";

    private AdView mBannerView;
    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {
        if(!(context instanceof Activity)){
            return;
        }
        int[] screenSizeDP = Util.getScreenSizeInDP(context);
        AdRequestConfig requestConfig = new AdRequestConfig.Builder()
                .AdType(AdConfig.AD_TYPE_BANNER)
                .slotId(mediationCustomServiceConfig.getADNNetworkSlotId()) //广告场景id
                .widthDp(screenSizeDP[0])
                .heightDp(0)//0为自适应
                .bannerInterval(0)//轮播时间 默认0
                .build();
        mBannerView = new AdView((Activity) context, requestConfig);
        mBannerView.setListener(new AdViewListener() {
            @Override
            public void onAdClick() {
                callBannerAdClick();
            }

            @Override
            public void onAdFailed(String msg) {
                callLoadFail(9999, msg);
            }

            @Override
            public void onAdReady(int price) {
                if (isClientBidding()) {
                    double ecpm = price;
                    if (ecpm < 0) {
                        ecpm = 0;
                    }
                    Log.e("CLOOOUD_POLY", "onAdReady: "+ecpm );
                    callLoadSuccess(ecpm);
                } else {
                    callLoadSuccess();
                }
            }

            @Override
            public void onAdShow(CAdInfo cAdInfo) {
                callBannerAdShow();
            }

            @Override
            public void onAdDismissed(String s) {
                callBannerAdClosed();
            }
        });

    }

    /**
     * 是否clientBidding广告
     *
     * @return
     */
    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }



    @Override
    public View getAdView() {
        Log.e("CLOOOUD_POLY", "getAdView: "+(mBannerView == null) );
        return mBannerView;
    }

    @Override
    public MediationConstant.AdIsReadyStatus isReadyCondition() {
        Log.e("CLOOOUD_POLY", "isReadyCondition: "+(mBannerView == null) );

        if(mBannerView != null){
            return MediationConstant.AdIsReadyStatus.AD_IS_READY;
        } else {
            return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }
}
