package com.example.gmadapter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.interstitial.MediationCustomInterstitialLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.open.ad.polyunion.bean.CAdInfo;
import com.open.ad.polyunion.listener.AdViewListener;
import com.open.ad.polyunion.view.AdConfig;
import com.open.ad.polyunion.view.AdRequestConfig;
import com.open.ad.polyunion.view.AdView;


/**
 * 插屏
 * */
public class CloooudMediationCustomInterstitialLoader extends MediationCustomInterstitialLoader {

    private AdView interstialAd;
    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {
        if(!(context instanceof Activity)){
            return;
        }
        AdRequestConfig requestConfig = new AdRequestConfig.Builder()
                .AdType(AdConfig.AD_TYPE_INTERSTITIAL)
                .slotId(mediationCustomServiceConfig.getADNNetworkSlotId()) //广告场景id
                .widthDp(300)
                .heightDp(300)
                .build();
        interstialAd = new AdView((Activity) context, requestConfig);
        interstialAd.setListener(new AdViewListener() {
            @Override
            public void onAdClick() {
                callInterstitialAdClick();
            }

            @Override
            public void onAdFailed(String msg) {
                callLoadFail(9999, msg);
            }

            @Override
            public void onAdReady(int price) {
                if (isClientBidding()) {
                    double ecpm = price;
                    if (ecpm < 0) {
                        ecpm = 0;
                    }
                    callLoadSuccess(ecpm);
                } else {
                    callLoadSuccess();
                }
            }

            @Override
            public void onAdShow(CAdInfo cAdInfo) {
                callInterstitialShow();
            }

            @Override
            public void onAdDismissed(String s) {
                callInterstitialClosed();
            }
        });

    }

    /**
     * 是否clientBidding广告
     *
     * @return
     */
    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }

    @Override
    public MediationConstant.AdIsReadyStatus isReadyCondition() {
        Log.e("CLOOOUD_POLY", "isReadyCondition: "+(interstialAd == null) );

        if(interstialAd != null){
            return MediationConstant.AdIsReadyStatus.AD_IS_READY;
        } else {
            return MediationConstant.AdIsReadyStatus.AD_IS_NOT_READY;
        }
    }

    @Override
    public void showAd(Activity activity) {
        if (interstialAd != null) {
            interstialAd.showInterstialAd(activity);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (interstialAd != null) {
            interstialAd.onDestroyAd();
        }
    }
}
