package com.example.gmadapter;

import android.content.Context;
import android.util.Log;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.mediation.MediationConstant;
import com.bytedance.sdk.openadsdk.mediation.bridge.custom.native_ad.MediationCustomNativeLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomServiceConfig;
import com.open.ad.polyunion.listener.NativeAdsListener;
import com.open.ad.polyunion.view.AdConfig;
import com.open.ad.polyunion.view.AdRequestConfig;
import com.open.ad.polyunion.view.NativeAd;
import com.open.ad.polyunion.view.NativeAdsResponse;

import java.util.ArrayList;
import java.util.List;


/**
 * 原生
 * */
public class CloooudMediationCustomNativeLoader extends MediationCustomNativeLoader {

    @Override
    public void load(Context context, AdSlot adSlot, MediationCustomServiceConfig mediationCustomServiceConfig) {
        getAdm();
        getExtraDataNoParse();
        int[] screenSizeDP = Util.getScreenSizeInDP(context);
        AdRequestConfig requestConfig = new AdRequestConfig.Builder()
                .AdType(AdConfig.AD_TYPE_INTERSTITIAL)
                .slotId(mediationCustomServiceConfig.getADNNetworkSlotId()) //广告场景id
                .isVideoVoiceOn(false)//视频播放是否有声音
                .requestCount(1) //信息流广告请求条数
                .widthDp(screenSizeDP[0]) //请求图片宽度dp值
                .heightDp(0) //请求图片高度dp值
                /**
                 * 设置视频自动播放场景：
                 * ALWAYS - 所有网络环境均自动播放
                 * WIFI - WIFI网络环境自动播放
                 * NEVER - 所有网络环境均不会自动播放
                 */
                .videoAutoPlayPolicy(AdRequestConfig.VideoAutoPlayPolicy.ALWAYS) //                .addSougouAdTemplate(AdTemplate.BIG_IMG_TPL_ID)
                //                .addSougouAdTemplate(AdTemplate.DOWNLOAD_BIG_TPL_ID)
                .showDownloadConfirmDialog(true)
                .build();

        NativeAd nativeAds = new NativeAd(context, requestConfig);
        nativeAds.setListener(new NativeAdsListener() {
            @Override
            public void onAdReady(List<NativeAdsResponse> responses) {
                if (responses == null || responses.size() == 0) {
                    callLoadFail(9999, "没有返回数据");
                    return;
                }
                List<CFeedNativeAD> adList = new ArrayList<>();
                for (NativeAdsResponse ad : responses) {
                    CFeedNativeAD nativeAdLoader = new CFeedNativeAD(context,ad);
                    if (isClientBidding()) {//bidding广告类型
                        double ecpm = ad.getPrice();//当无权限调用该接口时，SDK会返回错误码-1
                        if (ecpm < 0) {
                            ecpm = 0;
                        }
                        nativeAdLoader.setBiddingPrice(ecpm); //回传竞价广告价格
                    }
                    adList.add(nativeAdLoader);
                }
                callLoadSuccess(adList);
            }

            @Override
            public void onAdFailed(String msg) {
                Log.e("CLOOOUDAD", "NativeAd onAdFailed: $s");
                callLoadFail(9999, msg);
            }
        });
    }


    /**
     * 是否clientBidding广告
     *
     * @return
     */
    public boolean isClientBidding() {
        return getBiddingType() == MediationConstant.AD_TYPE_CLIENT_BIDING;
    }

}
