package com.example.gmadapter.init;


import android.app.Application;
import android.content.Context;

import com.bytedance.sdk.openadsdk.mediation.bridge.custom.MediationCustomInitLoader;
import com.bytedance.sdk.openadsdk.mediation.custom.MediationCustomInitConfig;
import com.open.ad.cloooud.api.listener.COaidProvider;
import com.open.ad.polyunion.newedition.contract.DeniedUpDeviceInfo;
import com.open.ad.polyunion.newedition.contract.InitSDKListener;
import com.open.ad.polyunion.view.AdConfig;
import com.open.ad.polyunion.view.AdView;
import com.open.ad.polyunion.view.InitSDKConfig;

import java.util.Map;

/**
 * 初始化
 * */
public class CloooudMediationCustomInitLoader extends MediationCustomInitLoader {

    /**
     * 初始化操作
     * */
    @Override
    public void initializeADN(Context context, MediationCustomInitConfig mediationCustomInitConfig, Map<String, Object> map) {
        if (!isInit()) {
            //聚合SDK初始化
            InitSDKConfig initSDKConfig  = new InitSDKConfig.Builder()
                    .AppId(mediationCustomInitConfig.getAppId())
                    .appName(mediationCustomInitConfig.getADNName())//SDK后台注册的应用名称
//                    .setChannel("demo")//渠道
                    // 竖屏 - AdConfig.REWARD_VIDEO_SCREEN_VERTICAL
                    // 横屏 - AdConfig.REWARD_VIDEO_SCREEN_x`HORIZONTAL
                    .RewardVideoScreenDirection(AdConfig.REWARD_VIDEO_SCREEN_VERTICAL) // 设置激励视频播放页面的横竖屏
                    .debug(true)////上线需要设置false
                    .setDeniedUpDeviceInfo(new DeniedUpDeviceInfo() {
                    })
                    .setOaidProvider(new COaidProvider() {
                        @Override
                        public String getOaid() {
                            return "";
                        }
                    }) //传入 OAID 获取器，建议集成 OAID SDK的应用设置
                    .build();
            AdView.initSDK((Application) context, initSDKConfig, new InitSDKListener() {
                @Override
                public void initializeSucceed() {
                    //初始化成功
                }

                @Override
                public void initializeFail() {
                    //初始化失败
                }
            });

        }
    }

    /**
     * 版本
     * */
    @Override
    public String getNetworkSdkVersion() {
       return "1.0";
    }
}
